package gov.va.med.mhv.usermgmt.data.model;

import gov.va.med.mhv.common.data.model.AbstractBaseEntity;
import gov.va.med.mhv.usermgmt.common.enums.Gender;
import gov.va.med.mhv.usermgmt.common.enums.Indicator;
import gov.va.med.mhv.usermgmt.common.enums.StatusType;

import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="MPI_TRACES")
public class Trace extends AbstractBaseEntity{
	
	private static final long serialVersionUID = 5460042551052557245L;
	
	@Id
	@Column(name="ID")
	@GeneratedValue(strategy=GenerationType.AUTO)
	private Long id;
	
	@Version
	@Column(name="OPLOCK")
    private Long oplock;
	
	@Column(name="CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
    private Date createdDate;
	
	@Column(name="MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
    private Date modifiedDate;
	
	@Column(name="STATUS")
    private String status;
	
	@Column(name="DIRECTION")
    private String direction;
	
    @Lob
    @Column(name="TRACE_DATA")
    private String traceData;
    
    @Column(name="STATUS_DATA")
    private String statusData;
    
    @ManyToOne
    @JoinColumn(name="EVENT_ID")
    private MpiEvent event;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getOplock() {
		return oplock;
	}

	public void setOplock(Long oplock) {
		this.oplock = oplock;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getDirection() {
		return direction;
	}

	public void setDirection(String direction) {
		this.direction = direction;
	}

	public String getTraceData() {
		return traceData;
	}

	public void setTraceData(String traceData) {
		this.traceData = traceData;
	}

	public String getStatusData() {
		return statusData;
	}

	public void setStatusData(String statusData) {
		this.statusData =((statusData!=null) && (statusData.length()>4000))
		? statusData.substring(0, 4000) : statusData;
	}

	public MpiEvent getEvent() {
		return event;
	}

	public void setEvent(MpiEvent event) {
		this.event = event;
	}
	
	private String serialize(Object obj){
		if (obj==null)
			return null;
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		java.beans.XMLEncoder enc = new java.beans.XMLEncoder(baos);
		enc.setPersistenceDelegate(StatusType.class, 
			new EnumPersistenceDelegate());
        enc.setPersistenceDelegate(Gender.class, new EnumPersistenceDelegate());
        enc.setPersistenceDelegate(Indicator.class, 
        	new EnumPersistenceDelegate());
        enc.setPersistenceDelegate(java.sql.Date.class, 
        		new DatePersistenceDelegate());
		enc.writeObject(obj);
		enc.close(); 
		byte[] barr = baos.toByteArray();
		String tmpData = (barr.length == 0 ? null : new String(barr));
		if(tmpData!=null)
			tmpData = tmpData.replaceAll(">\\s+<", "><");
		return tmpData;
	}
	
	// Jazz Defect 446144 -- Krish 20) Dynamic Code Evaluation: XMLDecoder Injection (1)
	// Instead we are using JAXB in PatientCorrelationServiceImpl class
	/*
	private Object deserialize(String str) {
		if (str == null) {
			return null;
		}
		byte[] barr = str.getBytes();
		ByteArrayInputStream bais = new ByteArrayInputStream(barr);
		java.beans.XMLDecoder dec = new java.beans.XMLDecoder(bais);
		Object result = dec.readObject();
		return result;
	}
	*/
	
	public void serializeTraceData(Object rawTraceData) {
		String tmpData = serialize(rawTraceData);
		setTraceData(tmpData);
	}

	// Jazz Defect 446144 -- Krish 20) Dynamic Code Evaluation: XMLDecoder Injection (1)
	// Instead we are using JAXB in PatientCorrelationServiceImpl class
	/*
	public Object deserializeTraceData() {
		Object result = deserialize(getTraceData());
		return result;
	}
	*/
	
	public void serializeStatusData(Object obj) {
		String tmpData = serialize(obj);
		setStatusData(tmpData);
	}
	
	// Jazz Defect 446144 -- Krish 20) Dynamic Code Evaluation: XMLDecoder Injection (1)
	// Instead we are using JAXB in PatientCorrelationServiceImpl class
	/*
	public Object deserializeStatusData() {
		Object result = deserialize(getStatusData());
		return result;
	}
	*/
	
	private static class DatePersistenceDelegate extends PersistenceDelegate {
		 
	    protected Expression instantiate(Object oldInstance, 
	    	java.beans.Encoder out) 
	    {
	        Date date = (Date) oldInstance;
	        return new Expression(oldInstance, date.getClass(),
	            "new", new Object[]{ date.getTime() }
	        );
	    }
	}

	private static class EnumPersistenceDelegate extends PersistenceDelegate {
	    
	    protected boolean mutatesTo( Object oldInstance, Object newInstance ) {
	        return oldInstance == newInstance;
	    }

	    protected Expression instantiate( Object oldInstance, Encoder out ) {
	        Enum e = ( Enum )oldInstance;
	        return new Expression( e, e.getClass(), "valueOf", 
	        	new Object[]{e.name()} );
	    }
	}

}
